//
//  SCFoundationMacros.h
//  SweetCocoaFoundation
//
//  Created by Rico on 6/18/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#define SC_RETURN_NIL_IF_NIL(object) if (object == nil) return nil;

#define SC_RETURN_IF_NIL(object) if (object == nil) return;


#define SC_KEYPATH(property) (@#property)

#define SC_PROPERTY_NAME(property) ((void)(NO && ((void)property, NO)), SCPropertyNameFromKeyPath(@#property))

#ifdef DEBUG
    #define SC_ASSERT_REQUIRED_OUTLET(outlet) NSAssert(outlet != nil, @"Required outlet not set: %@.", @#outlet)
#else
    #define SC_ASSERT_REQUIRED_OUTLET(outlet) do { if (outlet == nil) NSLog(@"Warning: Required outlet not set: %@ in %@.", @#outlet, [self class]); } while (0)
#endif

#define SCFloatsEqual(a,b)   (fabs((a) - (b)) < FLT_EPSILON)
#define SCFloatEqualsZero(a) (fabs(a) < FLT_EPSILON)

FOUNDATION_EXPORT NSString *SCPropertyNameFromKeyPath(NSString* keyPath);